<?php
require_once __DIR__ . '/../includes/config.php';
require_once __DIR__ . '/../includes/database.php';

$auth_token = $_COOKIE['rcp_auth'] ?? null;

if ($auth_token) {
    try {
        $pdo = Database::getInstance()->getConnection();
        $stmt = $pdo->prepare("DELETE FROM user_sessions WHERE session_id = ?");
        $stmt->execute([$auth_token]);
    } catch (Throwable $t) {
        // Ignore errors on logout
    }
}

// Clear cookie
setcookie('rcp_auth', '', [
    'expires' => time() - 3600,
    'path' => '/',
    'domain' => '.kwaggagroep.co.za',
    'secure' => true,
    'httponly' => true,
    'samesite' => 'Lax'
]);

header("Location: login.php");
exit;