<?php
// ERROR DISPLAY - ADD THIS AT THE TOP
error_reporting(E_ALL);
ini_set('display_errors', 1);
ini_set('log_errors', 1);
ini_set('error_log', __DIR__ . '/../php_errors.log');
// Your existing config code below...
/**
 * Recipe Control Pro - Unified Configuration
 * (Patched 2025-09-25T19:13:03)
 * NOTE: No closing ?> tag to avoid stray output.
 */

// Base URLs/Paths
define('APP_NAME', 'Recipe Control Pro');
define('APP_VERSION', '1.0.0');
define('APP_ENV', 'production'); // 'development' or 'production'
define('APP_URL', 'https://www.handelshuiskompanjie.co.za/rcp');
define('APP_TIMEZONE', 'Africa/Johannesburg');

// Filesystem base (absolute path) and web base (relative within domain)
define('BASE_PATH', __DIR__ . '/../');
define('WEB_BASE', '/rcp/');

// Database
define('DB_HOST', 'localhost');
define('DB_NAME', 'ccrahcmb_rcp');
define('DB_USER', 'ccrahcmb_rcp');
define('DB_PASS', 'P@ssword2025');
define('DB_CHARSET', 'utf8mb4');

// Sessions & Security
define('SESSION_TIMEOUT', 7200); // seconds
define('SESSION_PATH', BASE_PATH . 'storage/sessions');
define('LOG_PATH', BASE_PATH . 'storage/logs');
define('UPLOAD_LOGO_DIR', BASE_PATH . 'assets/uploads/logos');
define('ENCRYPTION_KEY', 'rcp-secure-key-2025-change-in-production');

// Error reporting (dev-friendly during bring-up)
if (APP_ENV === 'development') {
    error_reporting(E_ALL);
    ini_set('display_errors', '1');
    ini_set('display_startup_errors', '1');
} else {
    error_reporting(E_ALL & ~E_NOTICE & ~E_DEPRECATED & ~E_STRICT & ~E_WARNING);
    ini_set('display_errors', '0');
    ini_set('display_startup_errors', '0');
}

// Timezone
date_default_timezone_set(APP_TIMEZONE);

// Ensure required directories exist
foreach ([SESSION_PATH, LOG_PATH, UPLOAD_LOGO_DIR] as $dir) {
    if (!is_dir($dir)) @mkdir($dir, 0755, true);
}
