<?php
/**
 * Simple Authentication Guard
 */
session_start();

// Check if user is logged in
if (!isset($_SESSION['user_id'])) {
    header('Location: ' . WEB_BASE . 'pages/login.php');
    exit();
}

// Optional: Check if user has specific role
function require_role($required_role) {
    if ($_SESSION['user_role'] !== $required_role) {
        header('Location: ' . WEB_BASE . 'pages/dashboard.php');
        exit();
    }
}
?>