<?php require_once __DIR__ . '/../includes/page_guard.php'; ?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Meals - Recipe Control Pro</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="<?= BASE_PATH ?>assets/css/style.css" rel="stylesheet">
</head>
<body class="bg-light">
<?php include __DIR__ . '/../includes/navbar.php'; ?>

<main class="rcp-main">
  <div class="container-fluid py-4">
    <div class="row mb-4">
      <div class="col-12">
        <h1 class="h3 mb-1">Meal Planning</h1>
        <p class="text-muted">Build meals by combining multiple recipes</p>
      </div>
    </div>

    <div class="row g-4">
      <!-- Build Meal Card -->
      <div class="col-lg-5">
        <div class="card shadow-sm">
          <div class="card-header bg-white">
            <h5 class="card-title mb-0">Build New Meal</h5>
          </div>
          <div class="card-body">
            <form id="mealForm">
              <div class="mb-3">
                <label for="mealName" class="form-label">Meal Name *</label>
                <input type="text" class="form-control" id="mealName" name="name" required>
              </div>
              
              <div class="mb-3">
                <label for="mealDescription" class="form-label">Description</label>
                <textarea class="form-control" id="mealDescription" name="description" rows="2"
                          placeholder="Describe this meal combination"></textarea>
              </div>
              
              <div class="mb-3">
                <label for="mealCategory" class="form-label">Category</label>
                <input type="text" class="form-control" id="mealCategory" name="category"
                       placeholder="e.g., Buffet, Set Menu, Catering">
              </div>
              
              <div class="mb-3">
                <label for="mealType" class="form-label">Meal Type</label>
                <select class="form-select" id="mealType" name="meal_type">
                  <option value="">Select Type</option>
                  <option value="breakfast">Breakfast</option>
                  <option value="lunch">Lunch</option>
                  <option value="dinner">Dinner</option>
                  <option value="snack">Snack</option>
                  <option value="catering">Catering</option>
                </select>
              </div>
              
              <hr>
              
              <!-- Add Recipe to Meal -->
              <div class="mb-3">
                <label for="recipeSelect" class="form-label">Add Recipe to Meal</label>
                <div class="input-group">
                  <select class="form-select" id="recipeSelect">
                    <option value="">Select Recipe</option>
                  </select>
                  <input type="number" class="form-control" id="recipeServings" 
                         placeholder="Servings" value="1" min="1" style="max-width: 120px;">
                  <button class="btn btn-outline-secondary" type="button" id="addRecipeBtn">
                    <i class="fas fa-plus me-1"></i>Add
                  </button>
                </div>
              </div>
              
              <button type="submit" class="btn btn-success w-100">
                <i class="fas fa-save me-2"></i>Save Meal
              </button>
            </form>
            
            <!-- Selected Recipes -->
            <div class="mt-4">
              <div class="card border-primary">
                <div class="card-header bg-primary text-white d-flex justify-content-between align-items-center">
                  <span>Selected Recipes</span>
                  <span class="fw-bold" id="mealTotalCost">Total Cost: R 0.00</span>
                </div>
                <div class="card-body">
                  <div id="selectedRecipes" class="text-muted">
                    <i class="fas fa-info-circle me-1"></i>No recipes added yet
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
      
      <!-- Meals List -->
      <div class="col-lg-7">
        <div class="card shadow-sm">
          <div class="card-header bg-white d-flex justify-content-between align-items-center">
            <h5 class="card-title mb-0">My Meals</h5>
            <button class="btn btn-sm btn-outline-secondary" onclick="mealsManager.loadMeals()">
              <i class="fas fa-sync-alt me-1"></i>Refresh
            </button>
          </div>
          <div class="card-body">
            <div class="table-responsive">
              <table class="table table-hover">
                <thead class="table-light">
                  <tr>
                    <th>Name</th>
                    <th>Type</th>
                    <th>Recipes</th>
                    <th>Total Cost</th>
                    <th width="120" class="text-end">Actions</th>
                  </tr>
                </thead>
                <tbody id="mealsTable">
                  <tr>
                    <td colspan="5" class="text-center py-4">
                      <div class="spinner-border text-primary" role="status">
                        <span class="visually-hidden">Loading...</span>
                      </div>
                    </td>
                  </tr>
                </tbody>
              </table>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</main>

<!-- Meal Details Modal -->
<div class="modal fade" id="mealDetailsModal" tabindex="-1">
  <div class="modal-dialog modal-lg">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title">Meal Details</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
      </div>
      <div class="modal-body" id="mealDetailsBody">
        <!-- Content loaded dynamically -->
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
      </div>
    </div>
  </div>
</div>

<script src="<?= BASE_PATH ?>assets/js/meals_actions.js"></script>
<?php include __DIR__ . '/../includes/footer.php'; ?>
</body>
</html>