<?php
header('Content-Type: application/json');
require_once __DIR__ . '/../../includes/config.php';
require_once __DIR__ . '/../../includes/database.php';

$response = ['success' => false, 'data' => [], 'message' => ''];

try {
    $pdo = Database::getInstance()->getConnection();
    
    // Updated to properly get department information
    $stmt = $pdo->query("SELECT id, full_name, email, username, role, status, department, created_at FROM users ORDER BY created_at DESC");
    $users = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    $response['success'] = true;
    $response['data'] = $users;
    $response['message'] = 'Users loaded successfully';
    
} catch (Exception $e) {
    $response['message'] = 'Error: ' . $e->getMessage();
}

echo json_encode($response);
?>