<?php
header('Content-Type: application/json');
require_once __DIR__ . '/../../includes/config.php';
require_once __DIR__ . '/../../includes/database.php';

$response = ['success' => false, 'message' => ''];

try {
    $input = json_decode(file_get_contents('php://input'), true);
    
    if (!$input || !isset($input['id'])) {
        throw new Exception('Invalid user ID');
    }
    
    // Prevent deleting your own account
    session_start();
    if ($input['id'] == ($_SESSION['user_id'] ?? null)) {
        throw new Exception('You cannot delete your own account');
    }
    
    $pdo = Database::getInstance()->getConnection();
    
    $stmt = $pdo->prepare("DELETE FROM users WHERE id = ?");
    $success = $stmt->execute([$input['id']]);
    
    if ($success) {
        $response['success'] = true;
        $response['message'] = 'User deleted successfully';
    } else {
        throw new Exception('Failed to delete user');
    }
    
} catch (Exception $e) {
    $response['message'] = $e->getMessage();
}

echo json_encode($response);
?>