<?php
/**
 * Footer - Updated to use database settings
 */

// Get user data from database session
$user = null;
$company_name = 'Smart Serve Pro'; // Default
$auth_token = $_COOKIE['rcp_auth'] ?? null;

if ($auth_token) {
    try {
        require_once __DIR__ . '/config.php';
        require_once __DIR__ . '/database.php';
        require_once __DIR__ . '/SettingsManager.php';
        
        $pdo = Database::getInstance()->getConnection();
        $settingsManager = SettingsManager::getInstance();
        
        $stmt = $pdo->prepare("SELECT session_data FROM user_sessions WHERE session_id = ? AND expires_at > NOW()");
        $stmt->execute([$auth_token]);
        $session_data = $stmt->fetchColumn();
        
        if ($session_data) {
            $user = json_decode($session_data, true);
        }
        
        // Get company name from database settings
        $company_name = $settingsManager->get('company_name', 'Smart Serve Pro');
        
    } catch (Throwable $t) {
        // Silent fail
        error_log("Footer error: " . $t->getMessage());
    }
}

// Use existing constants
$base_path = defined('WEB_BASE') ? WEB_BASE : '/rcp/';
?>
<style>
    .rcp-footer {
        background: #8B0000 !important;
        color: #ffffff;
        padding: 14px 16px;
        text-align: center;
        font-size: 14px;
        margin-top: auto;
        border-top: 3px solid #600000;
    }
    html, body { 
        height: 100%; 
        margin: 0; 
    }
    body { 
        display: flex; 
        flex-direction: column; 
        min-height: 100vh; 
    }
    .rcp-main { 
        flex: 1 0 auto; 
        padding-top: 20px; 
    }
    .footer-company {
        font-weight: bold;
        color: #ffd700;
    }
</style>

<footer class="rcp-footer mt-5">
  <div class="container-fluid">
    <div class="row align-items-center">
      <div class="col-md-4 text-md-start">
        <strong>Logged in as:</strong> <?= htmlspecialchars($user['user_full_name'] ?? 'User') ?>
        (<?= htmlspecialchars($user['unit_name'] ?? 'Unknown Unit') ?>)
      </div>
      <div class="col-md-4 text-center">
        <strong>Registered to:</strong> <span class="footer-company"><?= htmlspecialchars($company_name) ?></span>
      </div>
      <div class="col-md-4 text-md-end">
        &copy; <?= date('Y') ?> Smart Serve Pro v1.0
        <span class="mx-2">|</span>
        <span>Developed by Thys Taljaard</span>
      </div>
    </div>
  </div>
</footer>

<!-- Bootstrap & FontAwesome -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
<script src="https://kit.fontawesome.com/6b0b64bce6.js" crossorigin="anonymous"></script>

<!-- Global JavaScript -->
<script src="<?= $base_path ?>assets/js/common.js"></script>