<?php
require_once __DIR__ . '/../includes/config.php';
require_once __DIR__ . '/../includes/database.php';

header('Content-Type: application/json');

function getSetting($pdo, $key, $default = '') {
    try {
        $stmt = $pdo->prepare("SELECT setting_value FROM system_settings WHERE setting_key = ?");
        $stmt->execute([$key]);
        $result = $stmt->fetchColumn();
        return $result !== false ? $result : $default;
    } catch (Exception $e) {
        return $default;
    }
}

function setSetting($pdo, $key, $value) {
    try {
        $stmt = $pdo->prepare(
            "INSERT INTO system_settings (setting_key, setting_value) 
             VALUES (?, ?) 
             ON DUPLICATE KEY UPDATE setting_value = VALUES(setting_value)"
        );
        return $stmt->execute([$key, $value]);
    } catch (Exception $e) {
        return false;
    }
}

$action = $_GET['action'] ?? '';
$pdo = Database::getInstance()->getConnection();

try {
    switch ($action) {
        case 'get_company':
            $settings = [
                'company_name' => getSetting($pdo, 'company_name', 'Smart Serve Pro'),
                'company_address' => getSetting($pdo, 'company_address', ''),
                'company_phone' => getSetting($pdo, 'company_phone', ''),
                'company_email' => getSetting($pdo, 'company_email', ''),
                'base_currency' => getSetting($pdo, 'base_currency', 'ZAR'),
                'decimal_places' => getSetting($pdo, 'decimal_places', '2'),
                'logo_path' => getSetting($pdo, 'logo_path', '')
            ];
            echo json_encode(['success' => true, 'settings' => $settings]);
            break;

        case 'save_company':
            setSetting($pdo, 'company_name', $_POST['company_name'] ?? '');
            setSetting($pdo, 'company_address', $_POST['company_address'] ?? '');
            setSetting($pdo, 'company_phone', $_POST['company_phone'] ?? '');
            setSetting($pdo, 'company_email', $_POST['company_email'] ?? '');
            setSetting($pdo, 'base_currency', $_POST['base_currency'] ?? 'ZAR');
            setSetting($pdo, 'decimal_places', $_POST['decimal_places'] ?? '2');
            
            echo json_encode(['success' => true, 'message' => 'Company settings saved']);
            break;

        case 'get_preferences':
            $settings = [
                'timezone' => getSetting($pdo, 'timezone', 'Africa/Johannesburg'),
                'date_format' => getSetting($pdo, 'date_format', 'Y-m-d')
            ];
            echo json_encode(['success' => true, 'settings' => $settings]);
            break;

        case 'save_preferences':
            setSetting($pdo, 'timezone', $_POST['timezone'] ?? 'Africa/Johannesburg');
            setSetting($pdo, 'date_format', $_POST['date_format'] ?? 'Y-m-d');
            echo json_encode(['success' => true, 'message' => 'Preferences saved']);
            break;

        case 'upload_logo':
            if (empty($_FILES['logo'])) {
                echo json_encode(['success' => false, 'message' => 'No file uploaded']);
                break;
            }
            
            $file = $_FILES['logo'];
            $uploadDir = __DIR__ . '/../assets/uploads/logos/';
            
            if (!is_dir($uploadDir)) {
                mkdir($uploadDir, 0755, true);
            }
            
            $allowedTypes = ['image/png', 'image/jpeg', 'image/gif', 'image/webp'];
            $maxSize = 2 * 1024 * 1024;
            
            if (!in_array($file['type'], $allowedTypes)) {
                echo json_encode(['success' => false, 'message' => 'Invalid file type']);
                break;
            }
            
            if ($file['size'] > $maxSize) {
                echo json_encode(['success' => false, 'message' => 'File too large (max 2MB)']);
                break;
            }
            
            $extension = pathinfo($file['name'], PATHINFO_EXTENSION);
            $filename = 'company_logo_' . time() . '.' . $extension;
            $filepath = $uploadDir . $filename;
            
            if (move_uploaded_file($file['tmp_name'], $filepath)) {
                $webPath = BASE_PATH . 'assets/uploads/logos/' . $filename;
                setSetting($pdo, 'logo_path', $webPath);
                echo json_encode(['success' => true, 'message' => 'Logo uploaded', 'logo_path' => $webPath]);
            } else {
                echo json_encode(['success' => false, 'message' => 'Error uploading file']);
            }
            break;

        case 'remove_logo':
            setSetting($pdo, 'logo_path', '');
            echo json_encode(['success' => true, 'message' => 'Logo removed']);
            break;

        default:
            echo json_encode(['success' => false, 'message' => 'Invalid action']);
    }
} catch (Exception $e) {
    echo json_encode(['success' => false, 'message' => 'Server error']);
}
?>