<?php
require_once __DIR__ . '/../../includes/config.php';
require_once __DIR__ . '/../../includes/database.php';

header('Content-Type: application/json');

if (!isset($_GET['meal_id'])) {
    http_response_code(400);
    echo json_encode(['error' => 'Meal ID is required']);
    exit;
}

$mealId = (int)$_GET['meal_id'];

try {
    $db = Database::getInstance();
    $pdo = $db->getConnection();
    
    $stmt = $pdo->prepare("
        SELECT 
            mc.*,
            cs.recipe_name as costing_name
        FROM meal_costings mc
        JOIN recipe_costings cs ON mc.costing_sheet_id = cs.id
        WHERE mc.meal_id = ?
    ");
    $stmt->execute([$mealId]);
    
    $costings = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    echo json_encode($costings);
    
} catch (Exception $e) {
    http_response_code(500);
    error_log("get_meal_costings.php error: " . $e->getMessage());
    echo json_encode(['error' => 'Failed to load meal costings: ' . $e->getMessage()]);
}
?>