<?php
require_once __DIR__ . '/../includes/config.php';
header('Content-Type: application/json');

try {
    $stmt = $pdo->query("
        SELECT cs.*, COUNT(cl.id) as ingredient_count 
        FROM costing_sheets cs 
        LEFT JOIN costing_lines cl ON cs.id = cl.costing_sheet_id 
        GROUP BY cs.id 
        ORDER BY cs.created_at DESC
    ");
    $sheets = $stmt->fetchAll(PDO::FETCH_ASSOC);
    echo json_encode($sheets);
} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode(['error' => 'Database error: ' . $e->getMessage()]);
}
?>